/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.items;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingLumberjack;
import com.minecolonies.coremod.items.AbstractItemMinecolonies;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class ItemScepterLumberjack
extends AbstractItemMinecolonies {
    private static final String NBT_START_POS = "minecolonies:start_pos";
    private static final String NBT_END_POS = "minecolonies:end_pos";

    public ItemScepterLumberjack(Item.Properties properties) {
        super("scepterlumberjack", properties.func_200917_a(1));
    }

    @NotNull
    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195991_k().field_72995_K) {
            return ActionResultType.FAIL;
        }
        ItemStack scepter = context.func_195999_j().func_184586_b(context.func_221531_n());
        LanguageHandler.sendPlayerMessage((PlayerEntity)context.func_195999_j(), (String)"item.minecolonies.scepterlumberjack.usedstart", (Object[])new Object[0]);
        if (this.setPosition(scepter.func_196082_o(), NBT_START_POS, context.func_195995_a(), context.func_195999_j())) {
            this.storeRestrictedArea(context.func_195999_j(), scepter.func_196082_o(), context.func_195991_k());
        }
        return ActionResultType.FAIL;
    }

    public boolean func_195938_a(@NotNull BlockState state, @NotNull World world, @NotNull BlockPos pos, @NotNull PlayerEntity player) {
        if (!world.field_72995_K) {
            ItemStack tool = player.func_184614_ca();
            LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"item.minecolonies.scepterlumberjack.usedend", (Object[])new Object[0]);
            if (this.setPosition(tool.func_196082_o(), NBT_END_POS, pos, player)) {
                this.storeRestrictedArea(player, tool.func_196082_o(), world);
            }
        }
        return false;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        return Float.MAX_VALUE;
    }

    private void storeRestrictedArea(PlayerEntity player, CompoundNBT compound, World worldIn) {
        int maxArea;
        int maxZ;
        int distZ;
        BlockPos startRestriction = BlockPosUtil.read(compound, NBT_START_POS);
        BlockPos endRestriction = BlockPosUtil.read(compound, NBT_END_POS);
        int minX = Math.min(startRestriction.func_177958_n(), endRestriction.func_177958_n());
        int minZ = Math.min(startRestriction.func_177952_p(), endRestriction.func_177952_p());
        int maxX = Math.max(startRestriction.func_177958_n(), endRestriction.func_177958_n());
        int distX = maxX - minX;
        int area = distX * (distZ = (maxZ = Math.max(startRestriction.func_177952_p(), endRestriction.func_177952_p())) - minZ);
        if (area > (maxArea = (int)Math.floor(2.0 * Math.pow(50.0, 2.0)))) {
            LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"item.minecolonies.scepterlumberjack.restrictiontoobig", (Object[])new Object[]{area, maxArea});
            return;
        }
        LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"item.minecolonies.scepterlumberjack.restrictionset", (Object[])new Object[]{minX, maxX, minZ, maxZ, area, maxArea});
        IColony colony = IColonyManager.getInstance().getColonyByWorld(compound.func_74762_e("id"), worldIn);
        BlockPos hutPos = BlockPosUtil.read(compound, "pos");
        BuildingLumberjack hut = colony.getBuildingManager().getBuilding(hutPos, BuildingLumberjack.class);
        if (hut == null) {
            return;
        }
        hut.setRestrictedArea(startRestriction, endRestriction);
    }

    private boolean setPosition(CompoundNBT compound, String key, BlockPos pos, PlayerEntity player) {
        if (compound.func_74764_b(key) && BlockPosUtil.read(compound, key).equals((Object)pos)) {
            player.field_71071_by.func_70304_b(player.field_71071_by.field_70461_c);
            return false;
        }
        BlockPosUtil.write(compound, key, pos);
        return compound.func_74764_b(NBT_END_POS) && compound.func_74764_b(NBT_START_POS);
    }
}

